<?php

namespace App\Http\Controllers;

use App\FetauredBlog;
use App\Blog;
use Illuminate\Http\Request;
use App\Http\Requests\UpdateFetauredBlogRequest;

class FetauredBlogController extends Controller
{
    /**
     * Display a listing of the resource.
     */
  

    public function get()
{
    $data = new \stdClass();
    // Fetch all blog names and their IDs for the select dropdown
    $data->blogNames = Blog::pluck('title', 'id');

    // Fetch the first FetauredBlog record
    $data2 = FetauredBlog::first();

    // If blog_names is stored as a JSON array (e.g., ["5", "7"]), decode it to an array
    $data2->blog_names = $data2 ? json_decode($data2->blog_names, true) : [];

    return view('admin.blog.setting', compact('data', 'data2'));
}


    public function update(Request $request)
    {
        if (config('app.demolock') == 1) {
            return back()->with('deleted', __('This action is disabled in the demo !'));
        }
        $data = FetauredBlog::first();
        $data->blog_names = $request->blog_names;
        $data->start_date = $request->start_date;
        $data->end_date = $request->end_date;
        $data->save();

        return back()->with('success', __('Blog Featured Settings Updated !'));
    }
}
